﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace Aggregation
{
    class Program
    {
        static void Main(string[] args)
        {
            List<CalendarEvent> events = new List<CalendarEvent>
            {
                new CalendarEvent
                {
                    Title = "Swingowa potańcówka na nabrzeżu",
                    StartTime = new DateTimeOffset (2009, 7, 11, 15, 00, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(4)
                },
                new CalendarEvent
                {
                    Title = "Sobotnia noc swingowa",
                    StartTime = new DateTimeOffset (2009, 7, 11, 19, 30, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(6.5)
                },
                new CalendarEvent
                {
                    Title = "Formula 1 - Grand Prix Niemiec",
                    StartTime = new DateTimeOffset (2009, 7, 12, 12, 10, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(3)
                },
                new CalendarEvent
                {
                    Title = "Piknik swingowy",
                    StartTime = new DateTimeOffset (2009, 7, 12, 15, 00, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(4)
                },
                new CalendarEvent
                {
                    Title = "Łamańce swingowe w klubie Setka",
                    StartTime = new DateTimeOffset (2009, 7, 13, 19, 45, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(5)
                }
            };

            double totalHours = events.Sum(ev => ev.Duration.TotalHours);
            Console.WriteLine(totalHours);

            // Listing 8-26. Implementacja operatora Count przy użyciu operatora Aggregate.
            int count = events.Aggregate(0, (c, ev) => c + 1);

            Console.WriteLine(count);


            double hours = events.Aggregate(0.0,
                (total, ev) => total + ev.Duration.TotalHours);

            Console.WriteLine(hours);


            double averageHours = events.Aggregate(
                new { TotalHours = 0.0, Count = 0 },
                (agg, ev) => new
                {
                    TotalHours = agg.TotalHours + ev.Duration.TotalHours,
                    Count = agg.Count + 1
                },
                (agg) => agg.TotalHours / agg.Count);

            Console.WriteLine(averageHours);
        }
    }
}
